CONST False = 0
CONST True = 1


' FLAC related variables

DIM INTEGER FLAC_PLAYING = False
DIM INTEGER FLAC_TRACK = 0
DIM STRING FLAC_FILE$ = ""


'!' QE related variables, constants, and initialization
'!
'!CONST QE_A_pin = 112 'PC10 (Nucleo V2 CN11-1 / CN8-6)
'!CONST QE_B_pin = 111 'PC11 (Nucleo V2 CN11-2 / CN8-8)
'!CONST QE_SW_pin = 113 'PC12 (Nucleo V2 CN11-3 / CN8-10)
'!
'!DIM INTEGER QE_CCW = False
'!DIM INTEGER QE_CW = False
'!DIM INTEGER ResetQE = True
'!DIM INTEGER QE_Value = 0
'!DIM INTEGER QE_LastValue = 0
'!DIM INTEGER QE_LastSwitch = 0


' Miscellaneous variables

DIM T = 0


'!' Enable interrupts on both edges of QE A & B signals, and set up switch pin
'!
'!Setpin QE_A_pin, intB, INT_QE, PULLUP
'!Setpin QE_B_pin, intB, INT_QE, PULLUP
'!SETPIN QE_SW_pin, DIN, PULLUP


T = TIMER + 30000  ' 30 seconds run time


DO

'!  ' Show current rotary encoder info if it has changed state
'!
'!  QE_Switch = PIN(QE_SW_pin)
'!  
'!  IF (QE_Value <> QE_LastValue) OR (QE_Switch <> QE_LastSwitch) THEN
'!
'!    PRINT QE_Value, QE_Switch
'!
'!    QE_LastValue = QE_Value
'!    QE_LastSwitch = QE_Switch
'!
'!  END IF
  
  ' Play audio (alternating tracks)
  
  IF NOT FLAC_PLAYING THEN

    FLAC_TRACK = FLAC_TRACK + 1
    IF FLAC_TRACK > 2 THEN
      FLAC_TRACK = 1
    END IF
    
    SELECT CASE FLAC_TRACK
      CASE 1: FLAC_FILE$ = "\Short.flac"
      CASE 2: FLAC_FILE$ = "\Short.flac"
      CASE ELSE: FLAC_FILE$ = ""
    END SELECT

    IF FLAC_FILE$ <> "" THEN

      FLAC_PLAYING = True
      PLAY FLAC FLAC_FILE$, INT_FLAC_DONE      
      PLAY VOLUME 10, 10

      PRINT
      PRINT "Playing track "; FLAC_TRACK; " ("; FLAC_FILE$; ")"
      PRINT

    END IF
      
  end if

  ' Continue looping until the time has elapsed.
  
LOOP UNTIL TIMER > T


PLAY STOP
FLAC_PLAYING = False


'-------------------------------------------------------------
'
' FLAC DONE Interrupt
'
'-------------------------------------------------------------

SUB INT_FLAC_DONE

  FLAC_PLAYING = False
  
  PRINT "-------------"
  PRINT "| FLAC DONE |"
  PRINT "-------------"
  
END SUB


'!'-------------------------------------------------------------
'!'
'!' QE (aka Rotary Encoder) Interrupt
'!'
'!'-------------------------------------------------------------
'!
'!SUB INT_QE
'!
'!' Original code from
'!' https://www.thebackshed.com/forum/ViewTopic.php?TID=10568&PID=124755#124755
'!' by @matherp & @goc
'!
'!INT_QE2:
'!
'!  QE_A = NOT PIN(QE_A_pin) 'Reverse sense to get positive logic
'!  QE_B = NOT PIN(QE_B_pin)
'!
'!  IF QE_A THEN
'!
'!    IF QE_B AND NOT ResetQE THEN 'QE_A and QE_B both active
'! 
'!      IF QE_CCW AND NOT QE_CW THEN
'!        QE_Value = FIX(Max(0, QE_Value-1)) 'Minimum of 0
'!        QE_CCW = False
'!      END IF
'!
'!      IF QE_CW AND NOT QE_CCW THEN
'!        QE_Value = FIX(Min(100, QE_Value+1)) 'Maximum of 100
'!        QE_CW = False
'!      END IF
'!
'!    ELSE 'Only QE_A active
'!
'!      IF ResetQE AND NOT QE_CCW THEN
'!        QE_CW = True
'!        ResetQE = False
'!      END IF
'!
'!    END IF
'!
'!  ELSE
'!
'!    IF QE_B THEN 'Only QE_B active
'!
'!      IF ResetQE AND NOT QE_CW THEN
'!        QE_CCW = True
'!        ResetQE = False
'!      END IF
'!
'!    ELSE 'Both off so reset
'!
'!      QE_CCW = False
'!      QE_CW = False
'!      ResetQE = True
'!
'!    END IF
'!
'!  END IF
'!
'!  IF PIN(QE_A_pin) = QE_A or PIN(QE_B_pin) = QE_B THEN GOTO INT_QE2 'Re-enter if another change has happened almost immediately
'!
'!END SUB

print "===== END OF PROGRAM ====="

' That's it, that's all.

END